#!/bin/bash

devdir="/dev"

while [ $# -gt 0 ]; do
	case $1 in
	-l)
		devdir="/dev/$2"
		;;
	-m)
		mode="$2"
		;;
	-g)
		group="$2"
		;;
	*)
		break
		;;
	esac
	shift
	shift
done

while [ $# -gt 0 ]; do
	if [ -e "$1" ]; then
		[ -n "$mode" ] && chmod $mode "$1"
		[ -n "$group" ] && chgrp $group "$1"

		if [ -n "$2" -a "$2" != "-" -a ! -L "$devdir/$2" ]; then
			[ -d "$devdir" ] || mkdir "$devdir"
			ln -sf "$1" "$devdir/$2"
		fi
	fi

	shift
	shift
done
