#!/bin/bash

cd /usr/lib/jmuconfig

# hang detection script [BSP-4643]
(
	sleep 20
	while true; do
		sleep 20
		[ ! -e /tmp/jmuconfig.ready ] && continue
		pgrep -f /etc/init.d/networking >/dev/null && continue
		curl -m 20 -s -o /dev/null localhost:3000/api/v1/system/status
		rc=$?
		pgrep -f /etc/init.d/networking >/dev/null && continue
		[ ${rc} -ne 0 ] && ( logger -t JMUConfig "hang detected - killing node!"; \
			pkill -f '^dbus-daemon .*dbus-jmuconfig.*' 2>/dev/null; \
			pkill -f '/usr/bin/node.* server.js' 2>/dev/null; \
			rm -f /tmp/jmuconfig.ready )
	done
) &

while [ 1 ];  do
	/usr/bin/node $@ 2>&1 | /usr/bin/logger -t JMUConfig
	echo "Node service terminated. Restart" | /usr/bin/logger -t JMUConfig
	sleep 1
done
