#!/bin/bash

. /etc/exorint.funcs

if [ "$1" != "start" ]
then
    exit 0;
fi

log()
{
    echo "Touchscreen init check $@" > /dev/kmsg
}

check_jsxx()
{
    find_touch="false";

    if [ -e /dev/input/touchscreen0 ]
    then
        find_touch="true"
    fi

    bootcount=$(hexdump -s1 -n1 -e '1/1 "%u"' /sys/bus/i2c/devices/0-0068/nvram)

    touch_type="$( exorint_cmdline_param touch_type )"

    if [ "$( exorint_ver_component )" == "M" ] && [ "$bootcount" -le "2" ] && [ "$touch_type" != "0" ] && [ "$touch_type" != "255" ]
    then
        if [ "$find_touch" == "false" ] &&  [ ! -e /dev/input/touchscreen0 ]
        then
            /etc/init.d/syslog start
            sleep 2;
            log "/dev/input/touchscreen0 not found! -- REBOOT";
            sync;
            reboot -f;
        fi
    fi
}

check_hsxx()
{
    #641 UN65 eTOP7xx US03: Force restart if mounting of USB touchscreen fails
    signature=$(hexdump -n2 -e '1/2 "%02x"' /sys/bus/i2c/devices/0-0056/eeprom)
    bootcount=$(hexdump -s1 -n1 -e '1/1 "%u"' /sys/bus/i2c/devices/0-0068/nvram)

    # only 2 bootcounter retries for touch to avoid entering ConfigOS
    if [ "$( exorint_ver_component )" == "M" ] && [ "$bootcount" -le "2" ] && [ "$signature" == "55aa" ]
    then
        find_touch="false";
        i=0;
        while [ $i -lt 3 ] && [ "$find_touch" == "false" ]
        do
            log "Try n. $i";
            if [ ! -e /dev/input/touchscreen0 ]
            then
                log "/dev/input/touchscreen0 not found, rebind usb.";
                echo usb1 > /sys/bus/usb/drivers/usb/unbind 2>/dev/null
                sleep 1;
                echo usb1 > /sys/bus/usb/drivers/usb/bind 2>/dev/null
                sleep 2;
            else
                find_touch="true"
            fi;
            i=$((i+1));
        done

        if [ "$find_touch" == "false" ] &&  [ ! -e /dev/input/touchscreen0 ]
        then
            /etc/init.d/syslog start
            sleep 2;
            log "/dev/input/touchscreen0 not found! -- REBOOT";
            sync;
            reboot -f;
        fi
    fi
}

case $(exorint_hwcode) in

    #ETOP7XX|ETOP7XXQ
    115|118)
        check_hsxx
        ;;

    #JSMART|JSMARTQ|JSMART05
    124|125|126)
        check_jsxx
        ;;
esac

# Blind device management
DEVICETYPE="$(exorint_ver_type)"
if [ "${DEVICETYPE}" = "ROUTER" ]; then
    grep -qE '^router\\autostart=' /etc/EPAD/system.ini || exorint_service_enable "router"
fi

# Add SEEPROM read permission to data group
EEPROM_PATH=/sys/class/i2c-dev/i2c-0/device
chgrp data $EEPROM_PATH/0-0050/eeprom $EEPROM_PATH/0-0054/eeprom
chmod 640 $EEPROM_PATH/0-0050/eeprom $EEPROM_PATH/0-0054/eeprom
