#!/bin/sh

JMUCONFIG_TESTURL="localhost:3000/api/v1/system"

. /etc/exorint.funcs
carrier=$(exorint_ver_carrier)
if [ "$carrier" == "WU16" ]
then
    /etc/init.d/dbus-1 start
fi

jmuconfig_wait()
{
    while true; do
        wget -O - "${JMUCONFIG_TESTURL}" >/dev/null 2>&1
        [ $? -eq 0 ] && break
        logger -t $0 "waiting for JMUConfig"
        sleep 1
    done
}

{
#   wait on /tmp/jmuconfig.ready is already done by browser flag (see /usr/bin/jmuconfig-app script)
#   jmuconfig_wait

    dbus-send --system --print-reply --dest=com.exor.EPAD '/' com.exor.EPAD.updateCursorVisibility

    logger -t $0 "Running jmuconfig-app"

    TMPDIR=/mnt/.psplash psplash-write QUIT

    # Change LED status to signal end of boot boot
    # LED value needs to be changed from EPAD to avoid unalignment
    case $(exorint_hwcode) in
    155) #X7HH
        if [ "$(exorint_cmdline_param touch_type)" = "0" ]; then
            dbus-send --print-reply --system --dest=com.exor.EPAD "/Leds" com.exor.EPAD.Leds.SetLedsJSON \
                    string:'[{ "id": 2, "mode": 1, "brightness": [0, 180, 0] }]'
        else
            dbus-send --print-reply --system --dest=com.exor.EPAD "/Leds" com.exor.EPAD.Leds.SetLedsJSON \
                    string:'[{ "id": 2, "mode": 1, "brightness": [0, 40, 0] }]'
        fi
        ;;
    144|147|159) #i5,i7,i10,i12
        dbus-send --print-reply --system --dest=com.exor.EPAD "/Leds" com.exor.EPAD.Leds.SetLedsJSON \
                string:'[{ "id": 2, "mode": 1, "brightness": [0, 0, 0] }]'
        ;;
    esac

    DISPLAY=:0 jmuconfig-app 2>&1 | logger -t JMUConfig-app

    sync

    [ ! -e /tmp/jmuconfig-app.kill ] && reboot -f
    rm /tmp/jmuconfig-app.kill

} &
