#!/bin/sh

[ -n "$EXORINT_FUNCS" ] || . /etc/exorint.funcs

case $(exorint_hwcode) in

	# ETOP7XX|ETOP7XXQ
	115|118)
		# Use autocalibration only for Rocktouch devices
		if ( grep  -q "Vendor=\(0eef\|222a\)" /proc/bus/input/devices ); then
			[ -x "/usr/bin/xinput_calibrator_once_exor.sh" ] && /usr/bin/xinput_calibrator_once_exor.sh
		else
			/usr/bin/xinput_calibrator_once.sh
		fi
		;;

	# WU16|WU16US03|JSMART|JSMARTQ|JSMART05|WU05|US04|WU10|TA19
	121|122|124|125|126|139|141|145|147|148)
		[ -x "/usr/bin/xinput_calibrator_once_exor.sh" ] && /usr/bin/xinput_calibrator_once_exor.sh
		;;
	*)
		# As a fallback we base the choice on the touch type
		if [ "$(exorint_cmdline_param touch_type)" = "0" ]; then
			/usr/bin/xinput_calibrator_once.sh
		else
			/usr/bin/xinput_calibrator_once_exor.sh
		fi
		;;
esac
