"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldHonorAE = void 0;

var _types = require("./types");

// This code is based on the `mssql-jdbc` library published under the conditions of MIT license.
// Copyright (c) 2019 Microsoft Corporation
const shouldHonorAE = (stmtColumnEncryptionSetting, columnEncryptionSetting) => {
  switch (stmtColumnEncryptionSetting) {
    case _types.SQLServerStatementColumnEncryptionSetting.Disabled:
    case _types.SQLServerStatementColumnEncryptionSetting.ResultSetOnly:
      return false;

    case _types.SQLServerStatementColumnEncryptionSetting.Enabled:
      return true;

    default:
      return columnEncryptionSetting;
  }
};

exports.shouldHonorAE = shouldHonorAE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJzaG91bGRIb25vckFFIiwic3RtdENvbHVtbkVuY3J5cHRpb25TZXR0aW5nIiwiY29sdW1uRW5jcnlwdGlvblNldHRpbmciLCJTUUxTZXJ2ZXJTdGF0ZW1lbnRDb2x1bW5FbmNyeXB0aW9uU2V0dGluZyIsIkRpc2FibGVkIiwiUmVzdWx0U2V0T25seSIsIkVuYWJsZWQiXSwic291cmNlcyI6WyIuLi8uLi9zcmMvYWx3YXlzLWVuY3J5cHRlZC91dGlscy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBUaGlzIGNvZGUgaXMgYmFzZWQgb24gdGhlIGBtc3NxbC1qZGJjYCBsaWJyYXJ5IHB1Ymxpc2hlZCB1bmRlciB0aGUgY29uZGl0aW9ucyBvZiBNSVQgbGljZW5zZS5cbi8vIENvcHlyaWdodCAoYykgMjAxOSBNaWNyb3NvZnQgQ29ycG9yYXRpb25cblxuaW1wb3J0IHsgU1FMU2VydmVyU3RhdGVtZW50Q29sdW1uRW5jcnlwdGlvblNldHRpbmcgfSBmcm9tICcuL3R5cGVzJztcblxuZXhwb3J0IGNvbnN0IHNob3VsZEhvbm9yQUUgPSAoc3RtdENvbHVtbkVuY3J5cHRpb25TZXR0aW5nOiBTUUxTZXJ2ZXJTdGF0ZW1lbnRDb2x1bW5FbmNyeXB0aW9uU2V0dGluZywgY29sdW1uRW5jcnlwdGlvblNldHRpbmc6IGJvb2xlYW4pOiBib29sZWFuID0+IHtcbiAgc3dpdGNoIChzdG10Q29sdW1uRW5jcnlwdGlvblNldHRpbmcpIHtcbiAgICBjYXNlIFNRTFNlcnZlclN0YXRlbWVudENvbHVtbkVuY3J5cHRpb25TZXR0aW5nLkRpc2FibGVkOlxuICAgIGNhc2UgU1FMU2VydmVyU3RhdGVtZW50Q29sdW1uRW5jcnlwdGlvblNldHRpbmcuUmVzdWx0U2V0T25seTpcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICBjYXNlIFNRTFNlcnZlclN0YXRlbWVudENvbHVtbkVuY3J5cHRpb25TZXR0aW5nLkVuYWJsZWQ6XG4gICAgICByZXR1cm4gdHJ1ZTtcbiAgICBkZWZhdWx0OlxuICAgICAgcmV0dXJuIGNvbHVtbkVuY3J5cHRpb25TZXR0aW5nO1xuICB9XG59O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBR0E7O0FBSEE7QUFDQTtBQUlPLE1BQU1BLGFBQWEsR0FBRyxDQUFDQywyQkFBRCxFQUF5RUMsdUJBQXpFLEtBQXVIO0VBQ2xKLFFBQVFELDJCQUFSO0lBQ0UsS0FBS0UsaURBQTBDQyxRQUEvQztJQUNBLEtBQUtELGlEQUEwQ0UsYUFBL0M7TUFDRSxPQUFPLEtBQVA7O0lBQ0YsS0FBS0YsaURBQTBDRyxPQUEvQztNQUNFLE9BQU8sSUFBUDs7SUFDRjtNQUNFLE9BQU9KLHVCQUFQO0VBUEo7QUFTRCxDQVZNIn0=