#!/bin/bash
#
# Mod user in /mnt/factory/shadow
set -e
if [ $# -lt 3 ]; then
        echo "Missing arguments."
	echo "Usage: $0 <username> <password> _=nochange <role> _=nochange [<daysexpiration>, 0=reset,-1=nochange] [<warningdays, 0=reset,-1=nochange>]"
        exit 1
fi

FACTORY_MNT="/mnt/factory/"
ETC_MNT="/etc/"
USER=$1
PASSW=$2
ROLE=$3
DAYS=$4
WDAYS=$5

LINECOUNT=0

[ -f /etc/shadow ] && LINECOUNT="$(cat /etc/shadow | grep "^$USER:" | wc -l)"
if [ $LINECOUNT -lt 1 ]; then
        echo "Invalid user $USER not existing"
        exit 2
fi


if [ "${ROLE}" != "admin" ] && [ "${ROLE}" != "user" ] && [ "${ROLE}" != "_" ]; then
	echo "Invalid role ${ROLE}"
	exit 3
fi

rm -f "${ETC_MNT}shadow" && cp "${FACTORY_MNT}shadow" "${ETC_MNT}"
rm -f "${ETC_MNT}group" && cp "${FACTORY_MNT}group" "${ETC_MNT}"
rm -f "${ETC_MNT}passwd" && cp "${FACTORY_MNT}passwd" "${ETC_MNT}"
if [ ! -z "${PASSW}" ] && [ "${PASSW}" != "_" ]; then
passwd $USER<<OEF
$PASSW
$PASSW
OEF
fi

if [ ! -z "${ROLE}" ] && [ "${ROLE}" != "_" ] && [ "${USER}" != "admin" ]; then
   usermod -G "" ${USER}
   if [ "${ROLE}" == "admin" ]; then
#	usermod -g admin ${USER}
	usermod -a -G admin,shadow,data,comm,datetime,fram,io,video,audio,pam_adm ${USER}
   else
#	usermod -g user ${USER}
	usermod -a -G user,data,datetime ${USER}
   fi
fi

if [ ! -z "$DAYS" -a "$DAYS" != "-1" ] || [ ! -z "$WDAYS" -a "$WDAYS" != "-1" ]; then
    [ "$DAYS" == "0" ] && DAYSOPT="--maxdays -1"
    [ "$WDAYS" == "0" ] && WDAYSOPT="-W -1"
    [ ! -z "$DAYS" -a "$DAYS" != "-1" -a "$DAYS" != "0" ] && DAYSOPT="--maxdays $DAYS"
    [ ! -z "$WDAYS" -a "$WDAYS" != "-1" -a "$WDAYS" != "0" ] && WDAYSOPT="-W $WDAYS"
    chage -I 1 $DAYSOPT $WDAYSOPT ${USER}
fi

mount -o remount,rw "${FACTORY_MNT}"
cp "${ETC_MNT}shadow" "${FACTORY_MNT}" && chgrp shadow "${FACTORY_MNT}shadow"
cp "${ETC_MNT}group" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}group"
cp "${ETC_MNT}passwd" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}passwd"
ln -sfb "${FACTORY_MNT}shadow" "${ETC_MNT}shadow"
ln -sfb "${FACTORY_MNT}group" "${ETC_MNT}group"
ln -sfb "${FACTORY_MNT}passwd" "${ETC_MNT}passwd"
sync
mount -o remount,ro "${FACTORY_MNT}"

exit 0
