#!/bin/sh -e

[ $# -ge 3 ] || exit 2

SELF_PATH="$(realpath "$0")"
SELF_DIR="$(dirname "$SELF_PATH")"
PUB_KEY="/usr/share/platform-keys/platform.pem"

OP="$1"
APP_DIR="$(realpath "$2")"
APP_NAME="$3"

( findmnt "$APP_DIR/rootfs" ) || exit 1

runc_kill() {
	( runc list | tail -n +2 | grep -q "^$1 " ) || return 0

	runc kill "$1" $2
	for i in $(seq 1 5); do
		runc delete "$1" && return 0
		sleep 1
	done
	return 1
}

case "$OP" in
	run)
		# BSP-4691 Drop caches to avoid CreateSharedImage error in chromium
		echo 1 > /proc/sys/vm/drop_caches

		container-network.sh create "$APP_NAME" "$APP_DIR/rootfs"
		runc run -d -b "$APP_DIR/rootfs" "$APP_NAME"
		;;
	stop)
		runc_kill "$APP_NAME" || runc_kill "$APP_NAME" 9
		container-network.sh remove "$APP_NAME"
		;;
	install)
		[ -f "$APP_DIR/rootfs/opt/app/$OP.sh" ] && "$APP_DIR/rootfs/opt/app/$OP.sh"
		;;
	uninstall)
		[ -f "$APP_DIR/rootfs/opt/app/$OP.sh" ] && "$APP_DIR/rootfs/opt/app/$OP.sh"
		umount "$APP_DIR/rootfs"
		veritysetup close "$APP_NAME"
		;;
	update)
		DEST_DIR="$4"
		FLAGS="$5"
		[ -f "$APP_DIR/rootfs/opt/app/$OP.sh" ] && "$APP_DIR/rootfs/opt/app/$OP.sh" "$DEST_DIR" "$FLAGS"
		;;
	*)
		exit 2
		;;
esac
