#!/bin/bash

# First parameter (audit size) must be in megabyte
AUDIT_ROTATE=4
AUDIT_SIZE_PERCENT=99
AUDIT_SIZE=$(($1 * 1024 * $AUDIT_SIZE_PERCENT / 100 / $AUDIT_ROTATE ))
# Optional second parameter (message size:default 2M) must be in megabyte
if [ ! -z "$2" ]; then
	MESSAGES_SIZE=$2
else
	MESSAGES_SIZE=2
fi

cat << EOF
# /etc/logrotate.d/rsyslog - Ported from Debian
/var/log/audit/audit
{
        size ${AUDIT_SIZE}k
        rotate ${AUDIT_ROTATE}
        missingok
        notifempty
        sharedscripts
        postrotate
            /usr/bin/pkill -HUP rsyslogd 2> /dev/null || true
        endscript
}

/var/log/messages
{
        size ${MESSAGES_SIZE}M
        rotate 4
        missingok
        notifempty
        sharedscripts
        postrotate
            /usr/bin/pkill -HUP rsyslogd 2> /dev/null || true
        endscript
}
EOF
