#!/bin/bash

USER="user"
LINECOUNT=0

[ -f /mnt/factory/shadow ] && LINECOUNT="$(cat /etc/shadow | grep "^$USER:"'!$1' | wc -l)"
if [ $LINECOUNT -gt 0 ]; then
        /usr/bin/deluser.sh ${USER}
fi

LINECOUNT="$(cat /etc/shadow | grep "^$USER:"'$6' | wc -l)"
if [ $LINECOUNT -gt 0 ]; then
	USERROLEFILE="/mnt/factory/userroles"
	ROLESFILE="/mnt/factory/roles"
	id -nG $USER | grep -qw "user"
	if [ $? -eq 0 ]; then
		#'user' is in group user
		/usr/bin/moduser.sh user _ user
		if [ ! -f "$ROLESFILE" ]; then
			#no role created
			mount -o remount,rw /mnt/factory
			echo "user:$USER" > "$USERROLEFILE"
			echo "user:localisation,system,logs,datetime,network,plugins,management,authentication,restart" > "$ROLESFILE"
			mount -o remount,ro /mnt/factory
		fi
	fi
fi
