#!/bin/bash

# We have now readopted the proprietary SiLabs driver instead of the community version -
# as for 1.0, the integrated interface name becomes wifi0 instead of wlan0

PRESERVEDPATH=$1
[ -z $PRESERVEDPATH ] && exit 1

# Exclusion for X5 / nsom01 which has TI wifi - assume all other archs may have SiLabs RS9113
cat /proc/cpuinfo | grep -q 'i.MX6 UltraLite' && exit 0

cp "$PRESERVEDPATH/etc/EPAD/system.ini" "$PRESERVEDPATH/etc/EPAD/system.ini.bak"
sed -i "s/wlan0/wifi0/g" "$PRESERVEDPATH/etc/EPAD/system.ini"

cp "$PRESERVEDPATH/etc/network/interfaces" "$PRESERVEDPATH/etc/network/interfaces.bak"
sed -i "s/wlan0/wifi0/g" "$PRESERVEDPATH/etc/network/interfaces"

[ -e "$PRESERVEDPATH/etc/hostapd/wlan0.conf" ] && mv "$PRESERVEDPATH/etc/hostapd/wlan0.conf" "$PRESERVEDPATH/etc/hostapd/wifi0.conf"
[ -e "$PRESERVEDPATH/etc/wpa_supplicant/wlan0.conf" ] && mv "$PRESERVEDPATH/etc/wpa_supplicant/wlan0.conf" "$PRESERVEDPATH/etc/wpa_supplicant/wifi0.conf"
