#!/bin/bash

exorint_extfsck() {
    e2fsck -p $1
    # If we still have unresolved errors run "fsck -y" and
    # if needed recreate the journal
    if [ $? -gt 3 ]; then
        e2fsck -y $1
        tune2fs -O has_journal $1
    fi
}

if [ "$1" != "start" ]
then
    exit 0;
fi

CONFIGOSPARTITION=/dev/mmcblk1p2
CONFIGOSTMPMNT=/mnt/configos
DATAPARTITION=/dev/mmcblk1p6
DATATMPMNT=/mnt/data

[ -e /etc/exorint.funcs ] && . /etc/exorint.funcs
carrier_ver=$( exorint_ver_carrier )

# Make sure data partition is mounted RW
if ( mount | grep $DATAPARTITION | grep -q -v rw, ); then
	[ "$ENABLE_ROOTFS_FSCK" = "yes" ] && exorint_extfsck $DATAPARTITION
	mount -o remount,rw $DATATMPMNT
	mount -o remount,rw /home
fi

if ! ( exorint_in_configos ) && [ ! -d $CONFIGOSTMPMNT ]; then
    mkdir $CONFIGOSTMPMNT
    mount -t ext4 -o ro $CONFIGOSPARTITION $CONFIGOSTMPMNT
fi

if [ "$carrier_ver" = "WU16" ] || [ "$carrier_ver" = "WU20" ] || [ "$carrier_ver" = "WU10" ]; then
    if [ ! -e /etc/udev.tar ] || [ "$( cat /proc/version /proc/devices /proc/bus/input/devices )" != "$( cat /etc/udev/cache.data )" ]; then
        cd /
        rm -rf /etc/udev.tar /etc/udev/cache.data
        sensors=""
        [ -e /dev/temp ] && sensors="$sensors dev/temp"
        [ -e /dev/temp_lps ] && sensors="$sensors dev/temp_lps"
        [ -e /dev/temp_htu ] && sensors="$sensors dev/temp_htu"
        [ -e /dev/temp_lm75 ] && sensors="$sensors dev/temp0 dev/temp_lm75"
        [ -e /dev/press ] && sensors="$sensors dev/press"
        [ -e /dev/light ] && sensors="$sensors dev/light"
        [ -e /dev/accel ] && sensors="$sensors dev/accel"
        tar cf /etc/udev.tar dev/spi* dev/i2c* dev/usb* \
                             dev/ttyO* dev/ttyS* dev/com* \
                             dev/ttmmxc* dev/STM* \
                             dev/input* dev/fram $sensors
        sync
        cat /proc/version /proc/devices /proc/bus/input/devices > /etc/udev/cache.data
    fi
fi

# BSP-2670 create plugins registry if not present
if [ ! -d /home/root/.cache/gstreamer-1.0 ]; then
    (
        # launch gst-launch with no argument. Application will return with an error but the plugins registry will be created
        HOME=/home/root gst-launch-1.0
    ) &
fi

# Blind device management
if [ "$(exorint_ver_type)" = "DEVICE" -o "$(exorint_ver_type)" = "ROUTER" ]; then
    sleep 1;
    # bootcounter reset - done by psplash for panels
    psplash-write "QUIT"
fi

exit 0
