#!/bin/sh

# Find the name of the script
cd $( dirname $0 )
SCRIPT_DIR="$( pwd )"
CONFIG="/mnt/data/hmi/pew/deploy/node/config/pew_log.json"
CONFIGPATH="/mnt/data/hmi/pew/deploy/node/config/log"
LOG_TEMPLATE="/mnt/data/hmi/pew/deploy/node/config/log/*.cfg"

export PATH="$SCRIPT_DIR/bin:/sbin:/bin:/usr/sbin:/usr/bin"
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib"

# Typical content during automatic start by jmLauncher
# $SCRIPT_DIR         /mnt/data/hmi/pew/deploy
# $LD_LIBRARY_PATH   /mnt/data/hmi/pew/deploy/lib
# $@                -kiosk
if [ ! -d "$CONFIGPATH" ]
then
	mkdir "$CONFIGPATH"
fi

if [ ! -e "$CONFIG" -a ! -h "$CONFIG" ]
then
	cp "$SCRIPT_DIR/config_default/pew_log.json" "$CONFIG"
	cp "$SCRIPT_DIR/config_default/log/*.cfg" "$LOG_TEMPLATE"
fi
sleep 3
/mnt/data/hmi/pew/deploy/bin/pew_log -l5
