"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _moneyn = _interopRequireDefault(require("./moneyn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x04]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallMoney = {
  id: 0x7A,
  type: 'MONEY4',
  name: 'SmallMoney',
  declaration: function () {
    return 'smallmoney';
  },
  generateTypeInfo: function () {
    return Buffer.from([_moneyn.default.id, 0x04]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(parameter.value * 10000, 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < -214748.3648 || value > 214748.3647) {
      throw new TypeError('Value must be between -214748.3648 and 214748.3647.');
    }

    return value;
  }
};
var _default = SmallMoney;
exports.default = _default;
module.exports = SmallMoney;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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