#!/bin/sh

# Find the name of the script
cd $( dirname $0 )
SCRIPT_DIR="$( pwd )"
CONFIGPATH="/mnt/data/hmi/pew/deploy/node/config/script"
CONFIG="/mnt/data/hmi/pew/deploy/node/config/pew_script.json"
SCRIPT="/mnt/data/hmi/pew/deploy/node/config/script/pew_script.cfg"

export PATH="$SCRIPT_DIR/bin:/sbin:/bin:/usr/sbin:/usr/bin"
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib"

# Typical content during automatic start by jmLauncher
# $SCRIPT_DIR         /mnt/data/hmi/pew/deploy
# $LD_LIBRARY_PATH   /mnt/data/hmi/pew/deploy/lib
# $@                -kiosk

if [ ! -d "$CONFIGPATH" ]
then
	mkdir "$CONFIGPATH"
fi

if [ ! -e "$CONFIG" -a ! -h "$CONFIG" ]
then
	cp "$SCRIPT_DIR/config_default/pew_script.json" "$CONFIG"
	cp "$SCRIPT_DIR/config_default/script/pew_script.cfg" "$SCRIPT"
fi
if [ ! -e "$SCRIPT" -a ! -h "$SCRIPT" ]
then
	cp "$SCRIPT_DIR/config_default/script/pew_script.cfg" "$SCRIPT"
fi
sleep 2
/mnt/data/hmi/pew/deploy/bin/pew_script -l5
