﻿var pewModule = require('./pew_module');
var pew = new pewModule.pewModule();
var moduleName = "sqlClient Connection test";
//Catch exceptions
process.on('uncaughtException', function (err) {
    pew.sysLogMessage(moduleName, "Uncaught exception: " + err.stack);
})

var db, dbConfig;
var sqlConfig = pew.getConfFileSync(pew.Constants.requests.READ_SQL);

if (sqlConfig.err) {
    return console.log("Read configuration error");
}

let dbTypes = {
    mssql: 0,
    mysql: 1,
    postgres: 2,
    mariadb: 3,
    azure: 4
}

pew.getKeyContent().then(key => {
    pew.Constants.pwkey = key;
    switch (sqlConfig.data.db_type) {
        case dbTypes.mssql:
        case dbTypes.azure:
            db = require("mssql");
            dbConfig = {
                user: sqlConfig.data.user,
                password: pew.decryptPW(sqlConfig.data.pass),
                database: sqlConfig.data.instance_name,
                server: sqlConfig.data.server,
                port: sqlConfig.data.port,
                connectionTimeout: sqlConfig.data.timeout,
                options: {
                    encrypt: sqlConfig.data.db_type === dbTypes.azure ? true : !!sqlConfig.data.use_encryption, // for azure
                    trustServerCertificate: sqlConfig.data.db_type === dbTypes.azure ? false : !sqlConfig.data.ca_verification, // change to true for local dev / self-signed certs
                },
            }

            db.connect(dbConfig).then(() => {
                console.log(pew.Constants.API_TEST_SUCCESS);
                return;
            }).catch(err => {
                console.log(err.message);
                return;
            }).finally(() => {
                db.close();
            })
            break;

        case dbTypes.mysql:
        case dbTypes.mariadb:
            db = require("mysql");
            dbConfig = db.createConnection({
                host: sqlConfig.data.server,
                user: sqlConfig.data.user,
                password: pew.decryptPW(sqlConfig.data.pass),
                database: sqlConfig.data.instance_name,
                port: sqlConfig.data.port,
                connectTimeout: sqlConfig.data.timeout,
                ssl: sqlConfig.data.use_encryption ? {
                    rejectUnauthorized: !!sqlConfig.data.ca_verification,
                    ca: sqlConfig.data.ca !== pew.Constants.EMPTY_STRING ? fs.readFileSync(path.join(__dirname, pew.Constants.configSubfolders.sql, sqlConfig.data.ca)) : null,
                    cert: sqlConfig.data.client !== pew.Constants.EMPTY_STRING ? fs.readFileSync(path.join(__dirname, pew.Constants.configSubfolders.sql, sqlConfig.data.client)) : null,
                    key: sqlConfig.data.key !== pew.Constants.EMPTY_STRING ? fs.readFileSync(path.join(__dirname, pew.Constants.configSubfolders.sql, sqlConfig.data.key)) : null,
                } : null
            })
            dbConfig.connect(err => {
                if (err) {
                    console.log(err.message);
                }
                else {
                    console.log(pew.Constants.API_TEST_SUCCESS)
                }
                dbConfig.end();
                return;
            })
            break;

        case dbTypes.postgres:
            db = require("pg");
            dbConfig = new db.Client({
                host: sqlConfig.data.server,
                port: sqlConfig.data.port,
                user: sqlConfig.data.user,
                password: pew.decryptPW(sqlConfig.data.pass),
                database: sqlConfig.data.instance_name,
                connectionTimeoutMillis: sqlConfig.data.timeout,
                ssl: sqlConfig.data.use_encryption ? {
                    rejectUnauthorized: !!sqlConfig.data.ca_verification,
                    ca: sqlConfig.data.ca !== pew.Constants.EMPTY_STRING ? fs.readFileSync(path.join(__dirname, pew.Constants.configSubfolders.sql, sqlConfig.data.ca)) : null,
                    cert: sqlConfig.data.client !== pew.Constants.EMPTY_STRING ? fs.readFileSync(path.join(__dirname, pew.Constants.configSubfolders.sql, sqlConfig.data.client)) : null,
                    key: sqlConfig.data.key !== pew.Constants.EMPTY_STRING ? fs.readFileSync(path.join(__dirname, pew.Constants.configSubfolders.sql, sqlConfig.data.key)) : null,
                } : null
            })

            dbConfig.connect(err => {
                if (err) {
                    console.log(err.message);
                }
                else {
                    console.log(pew.Constants.API_TEST_SUCCESS)
                }
                dbConfig.end();
                return;
            })
            break;
    }
}).catch(err => console.log("err: " + err))



