"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconvLite = _interopRequireDefault(require("iconv-lite"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const Text = {
  id: 0x23,
  type: 'TEXT',
  name: 'Text',
  hasTableName: true,
  declaration: function () {
    return 'text';
  },
  resolveLength: function (parameter) {
    const value = parameter.value;

    if (value != null) {
      return value.length;
    } else {
      return -1;
    }
  },

  generateTypeInfo(parameter, _options) {
    const buffer = Buffer.alloc(10);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 5, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(value.length, 0);
    return buffer;
  },

  generateParameterData: function* (parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return;
    }

    yield value;
  },
  validate: function (value, collation) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }

    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }

    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = Text;
exports.default = _default;
module.exports = Text;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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