/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Known values of {@link ApiVersion74} that the service accepts. */
export var KnownApiVersion74;
(function (KnownApiVersion74) {
    /** Api Version '7.4' */
    KnownApiVersion74["Seven4"] = "7.4";
})(KnownApiVersion74 || (KnownApiVersion74 = {}));
/** Known values of {@link JsonWebKeyType} that the service accepts. */
export var KnownJsonWebKeyType;
(function (KnownJsonWebKeyType) {
    /** Elliptic Curve. */
    KnownJsonWebKeyType["EC"] = "EC";
    /** Elliptic Curve with a private key which is stored in the HSM. */
    KnownJsonWebKeyType["ECHSM"] = "EC-HSM";
    /** RSA (https://tools.ietf.org/html/rfc3447) */
    KnownJsonWebKeyType["RSA"] = "RSA";
    /** RSA with a private key which is stored in the HSM. */
    KnownJsonWebKeyType["RSAHSM"] = "RSA-HSM";
    /** Octet sequence (used to represent symmetric keys) */
    KnownJsonWebKeyType["Oct"] = "oct";
    /** Octet sequence (used to represent symmetric keys) which is stored the HSM. */
    KnownJsonWebKeyType["OctHSM"] = "oct-HSM";
})(KnownJsonWebKeyType || (KnownJsonWebKeyType = {}));
/** Known values of {@link JsonWebKeyOperation} that the service accepts. */
export var KnownJsonWebKeyOperation;
(function (KnownJsonWebKeyOperation) {
    KnownJsonWebKeyOperation["Encrypt"] = "encrypt";
    KnownJsonWebKeyOperation["Decrypt"] = "decrypt";
    KnownJsonWebKeyOperation["Sign"] = "sign";
    KnownJsonWebKeyOperation["Verify"] = "verify";
    KnownJsonWebKeyOperation["WrapKey"] = "wrapKey";
    KnownJsonWebKeyOperation["UnwrapKey"] = "unwrapKey";
    KnownJsonWebKeyOperation["Import"] = "import";
    KnownJsonWebKeyOperation["Export"] = "export";
})(KnownJsonWebKeyOperation || (KnownJsonWebKeyOperation = {}));
/** Known values of {@link DeletionRecoveryLevel} that the service accepts. */
export var KnownDeletionRecoveryLevel;
(function (KnownDeletionRecoveryLevel) {
    /** Denotes a vault state in which deletion is an irreversible operation, without the possibility for recovery. This level corresponds to no protection being available against a Delete operation; the data is irretrievably lost upon accepting a Delete operation at the entity level or higher (vault, resource group, subscription etc.) */
    KnownDeletionRecoveryLevel["Purgeable"] = "Purgeable";
    /** Denotes a vault state in which deletion is recoverable, and which also permits immediate and permanent deletion (i.e. purge). This level guarantees the recoverability of the deleted entity during the retention interval (90 days), unless a Purge operation is requested, or the subscription is cancelled. System wil permanently delete it after 90 days, if not recovered */
    KnownDeletionRecoveryLevel["RecoverablePurgeable"] = "Recoverable+Purgeable";
    /** Denotes a vault state in which deletion is recoverable without the possibility for immediate and permanent deletion (i.e. purge). This level guarantees the recoverability of the deleted entity during the retention interval(90 days) and while the subscription is still available. System wil permanently delete it after 90 days, if not recovered */
    KnownDeletionRecoveryLevel["Recoverable"] = "Recoverable";
    /** Denotes a vault and subscription state in which deletion is recoverable within retention interval (90 days), immediate and permanent deletion (i.e. purge) is not permitted, and in which the subscription itself  cannot be permanently canceled. System wil permanently delete it after 90 days, if not recovered */
    KnownDeletionRecoveryLevel["RecoverableProtectedSubscription"] = "Recoverable+ProtectedSubscription";
    /** Denotes a vault state in which deletion is recoverable, and which also permits immediate and permanent deletion (i.e. purge when 7<= SoftDeleteRetentionInDays < 90). This level guarantees the recoverability of the deleted entity during the retention interval, unless a Purge operation is requested, or the subscription is cancelled. */
    KnownDeletionRecoveryLevel["CustomizedRecoverablePurgeable"] = "CustomizedRecoverable+Purgeable";
    /** Denotes a vault state in which deletion is recoverable without the possibility for immediate and permanent deletion (i.e. purge when 7<= SoftDeleteRetentionInDays < 90).This level guarantees the recoverability of the deleted entity during the retention interval and while the subscription is still available. */
    KnownDeletionRecoveryLevel["CustomizedRecoverable"] = "CustomizedRecoverable";
    /** Denotes a vault and subscription state in which deletion is recoverable, immediate and permanent deletion (i.e. purge) is not permitted, and in which the subscription itself cannot be permanently canceled when 7<= SoftDeleteRetentionInDays < 90. This level guarantees the recoverability of the deleted entity during the retention interval, and also reflects the fact that the subscription itself cannot be cancelled. */
    KnownDeletionRecoveryLevel["CustomizedRecoverableProtectedSubscription"] = "CustomizedRecoverable+ProtectedSubscription";
})(KnownDeletionRecoveryLevel || (KnownDeletionRecoveryLevel = {}));
/** Known values of {@link JsonWebKeyCurveName} that the service accepts. */
export var KnownJsonWebKeyCurveName;
(function (KnownJsonWebKeyCurveName) {
    /** The NIST P-256 elliptic curve, AKA SECG curve SECP256R1. */
    KnownJsonWebKeyCurveName["P256"] = "P-256";
    /** The NIST P-384 elliptic curve, AKA SECG curve SECP384R1. */
    KnownJsonWebKeyCurveName["P384"] = "P-384";
    /** The NIST P-521 elliptic curve, AKA SECG curve SECP521R1. */
    KnownJsonWebKeyCurveName["P521"] = "P-521";
    /** The SECG SECP256K1 elliptic curve. */
    KnownJsonWebKeyCurveName["P256K"] = "P-256K";
})(KnownJsonWebKeyCurveName || (KnownJsonWebKeyCurveName = {}));
/** Known values of {@link JsonWebKeyEncryptionAlgorithm} that the service accepts. */
export var KnownJsonWebKeyEncryptionAlgorithm;
(function (KnownJsonWebKeyEncryptionAlgorithm) {
    KnownJsonWebKeyEncryptionAlgorithm["RSAOaep"] = "RSA-OAEP";
    KnownJsonWebKeyEncryptionAlgorithm["RSAOaep256"] = "RSA-OAEP-256";
    KnownJsonWebKeyEncryptionAlgorithm["RSA15"] = "RSA1_5";
    KnownJsonWebKeyEncryptionAlgorithm["A128GCM"] = "A128GCM";
    KnownJsonWebKeyEncryptionAlgorithm["A192GCM"] = "A192GCM";
    KnownJsonWebKeyEncryptionAlgorithm["A256GCM"] = "A256GCM";
    KnownJsonWebKeyEncryptionAlgorithm["A128KW"] = "A128KW";
    KnownJsonWebKeyEncryptionAlgorithm["A192KW"] = "A192KW";
    KnownJsonWebKeyEncryptionAlgorithm["A256KW"] = "A256KW";
    KnownJsonWebKeyEncryptionAlgorithm["A128CBC"] = "A128CBC";
    KnownJsonWebKeyEncryptionAlgorithm["A192CBC"] = "A192CBC";
    KnownJsonWebKeyEncryptionAlgorithm["A256CBC"] = "A256CBC";
    KnownJsonWebKeyEncryptionAlgorithm["A128Cbcpad"] = "A128CBCPAD";
    KnownJsonWebKeyEncryptionAlgorithm["A192Cbcpad"] = "A192CBCPAD";
    KnownJsonWebKeyEncryptionAlgorithm["A256Cbcpad"] = "A256CBCPAD";
})(KnownJsonWebKeyEncryptionAlgorithm || (KnownJsonWebKeyEncryptionAlgorithm = {}));
/** Known values of {@link JsonWebKeySignatureAlgorithm} that the service accepts. */
export var KnownJsonWebKeySignatureAlgorithm;
(function (KnownJsonWebKeySignatureAlgorithm) {
    /** RSASSA-PSS using SHA-256 and MGF1 with SHA-256, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["PS256"] = "PS256";
    /** RSASSA-PSS using SHA-384 and MGF1 with SHA-384, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["PS384"] = "PS384";
    /** RSASSA-PSS using SHA-512 and MGF1 with SHA-512, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["PS512"] = "PS512";
    /** RSASSA-PKCS1-v1_5 using SHA-256, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["RS256"] = "RS256";
    /** RSASSA-PKCS1-v1_5 using SHA-384, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["RS384"] = "RS384";
    /** RSASSA-PKCS1-v1_5 using SHA-512, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["RS512"] = "RS512";
    /** Reserved */
    KnownJsonWebKeySignatureAlgorithm["Rsnull"] = "RSNULL";
    /** ECDSA using P-256 and SHA-256, as described in https://tools.ietf.org/html/rfc7518. */
    KnownJsonWebKeySignatureAlgorithm["ES256"] = "ES256";
    /** ECDSA using P-384 and SHA-384, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["ES384"] = "ES384";
    /** ECDSA using P-521 and SHA-512, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["ES512"] = "ES512";
    /** ECDSA using P-256K and SHA-256, as described in https://tools.ietf.org/html/rfc7518 */
    KnownJsonWebKeySignatureAlgorithm["ES256K"] = "ES256K";
})(KnownJsonWebKeySignatureAlgorithm || (KnownJsonWebKeySignatureAlgorithm = {}));
/** Known values of {@link KeyEncryptionAlgorithm} that the service accepts. */
export var KnownKeyEncryptionAlgorithm;
(function (KnownKeyEncryptionAlgorithm) {
    KnownKeyEncryptionAlgorithm["CKMRSAAESKEYWrap"] = "CKM_RSA_AES_KEY_WRAP";
    KnownKeyEncryptionAlgorithm["RSAAESKEYWrap256"] = "RSA_AES_KEY_WRAP_256";
    KnownKeyEncryptionAlgorithm["RSAAESKEYWrap384"] = "RSA_AES_KEY_WRAP_384";
})(KnownKeyEncryptionAlgorithm || (KnownKeyEncryptionAlgorithm = {}));
//# sourceMappingURL=index.js.map