#!/bin/bash

. /etc/exorint.funcs

# Migration is necessary only for UN68 for which GPU has now been disabled
[ "$(exorint_ver_bsp)" = "UN68" ] || exit 0

FACTORYPARTITION=/dev/mmcblk1p1
FACTORYMNT=/mnt/factory

mount -o remount,rw "$FACTORYPARTITION" "$FACTORYMNT"

# Create X11 rotation config file
if [ -e "$FACTORYMNT"/etc/rotation ]; then
	read ROTATION < "$FACTORYMNT"/etc/rotation
	case "$ROTATION" in
		90)
			DIRECTION="CCW" ;;
		180)
			DIRECTION="UD" ;;
		270)
			DIRECTION="CW" ;;
		*)
			DIRECTION="" ;;
	esac
	if [ "$DIRECTION" = "" ]; then
		echo "No rotation to be applied"
		rm -f "$FACTORYMNT"/etc/X11/xorg.conf.d/x11-rotate.conf
	else
		echo "Applying rotation $ROTATION = direction $DIRECTION"
		mkdir -p "$FACTORYMNT"/etc/X11/xorg.conf.d/
	cat << EOF > "$FACTORYMNT"/etc/X11/xorg.conf.d/x11-rotate.conf
Section "Device"
Identifier "/dev/fb0"
Option "Rotate" "${DIRECTION}"
EndSection
EOF
	fi
fi

mount -o remount,ro "$FACTORYPARTITION" "$FACTORYMNT"
