#!/bin/sh

[ -n "$EXORINT_FUNCS" ] || . /etc/exorint.funcs

[ -d "/mnt/data/hmi" ] || mkdir /mnt/data/hmi

# Dummy call to wait for EPAD initialization
dbus-send --system --print-reply --dest=com.exor.EPAD '/' com.exor.EPAD.ping

dbus-send --system --print-reply --dest=com.exor.EPAD '/' com.exor.EPAD.updateCursorVisibility

ifconfig lo up

. /etc/default/rcS

bspVers="$( cat /boot/version )"
VER_CARRIER=$(echo -n "${bspVers:4:2}")

if [ -z "$FASTBOOT" -o ! "$VER_CARRIER" == "WU" -o -z "$(pgrep HMI)" ]; then
    if [ -e /etc/nokiosk ]; then
        echo "HMI: NOKIOSK" | logger
        # starts the HMI
        mv /etc/nokiosk /var/run/
        dbus-send --system --print-reply --dest=com.exor.JMLauncher '/' com.exor.JMLauncher.launchDesktop
    else
        echo "HMI: KIOSK" | logger
        ( dbus-send --system --print-reply --dest=com.exor.JMLauncher '/' com.exor.JMLauncher.launchHMI | logger ) &
        sleep 10
    fi
else
    echo "HMI: KIOSK FASTBOOT" | logger
fi

# Change LED status to signal end of boot boot
# LED value needs to be changed from EPAD to avoid unalignment
case $(exorint_hwcode) in
155) #X7HH
	if [ "$(exorint_cmdline_param touch_type)" = "0" ]; then
		dbus-send --print-reply --system --dest=com.exor.EPAD "/Leds" com.exor.EPAD.Leds.SetLedsJSON \
			string:'[{ "id": 2, "mode": 1, "brightness": [0, 180, 0] }]'
	else
		dbus-send --print-reply --system --dest=com.exor.EPAD "/Leds" com.exor.EPAD.Leds.SetLedsJSON \
			string:'[{ "id": 2, "mode": 1, "brightness": [0, 40, 0] }]'
	fi
	;;
144|147|159) #i5,i7,i10,i12
	dbus-send --print-reply --system --dest=com.exor.EPAD "/Leds" com.exor.EPAD.Leds.SetLedsJSON \
		string:'[{ "id": 2, "mode": 1, "brightness": [0, 0, 0] }]'
	;;
esac
