#!/bin/bash
#
# Activate setgid bit on data partition mountpoint so directories and files
# inherit group permissions

. /etc/default/rcS

if [ "${DEVNAME}" = "${DATAPARTITION}" -a "${SECURE_BOOT}" != "yes" ] || [ "${DM_NAME}" = "data" ]; then
  MNT="${DATAMNT}"
elif [ "${DEVNAME}" = "${DATA2PARTITION}" ]; then
  MNT="${DATA2MNT}"
else
  exit 0
fi

[ -d "${MNT}" ] || exit 0

chgrp data "${MNT}"
chmod 2774 "${MNT}"  # setgid + rwx for group
