#!/bin/bash

cat << EOF
# *GENERATED by $0 - do not modify! *

#
# General Config
#

map_hash_bucket_size 128;
# for Websocket proxying
map \$http_upgrade \$connection_upgrade {
    default upgrade;
    '' close;
}

EOF

jm_enabled=$(sys_params -l services/web_server/proxy/jmobile/enabled 2> /dev/null)
corsenabled=$(sys_params -l services/web_server/cors/enabled 2> /dev/null)

if [ "$corsenabled" = "true" ]; then
	corsdomain=$(sys_params -l services/web_server/cors/domains 2> /dev/null)
	echo "map \$http_origin \$cors_header {"

	if [ -z "$corsdomain" ]; then
		echo "    default \"\$http_origin\";"
	elif [ "${corsdomain:0:3}" = "re:" ]; then
		echo "    default \"\";"
		echo "    '~${corsdomain:3}' \"\$http_origin\";"
	else
		echo "    default \"$corsdomain\";"
	fi
	echo "}"
fi

cat << EOF

#
# Upstream definitions
#

EOF

if [ "$jm_enabled" != "false" ]; then
        cat << EOF
upstream jmobile {
    server 127.0.0.1:8000;
}

EOF
fi

cat << EOF
upstream jmuconfig {
    server 127.0.0.1:8080;
}

upstream nodejs {
    server 127.0.0.1:3000;
}

upstream cloudservice {
    server 127.0.0.1:4804;
}

#upstream test {
#    server 127.0.0.1:8001;
#}

#
# Servers
#
EOF

if [ "$(sys_params -l services/web_server/https_only 2> /dev/null)" = "false" ]; then
cat << EOF
# external HTTP requests are redirected to HTTPS
server {
    listen      80;

EOF

	if [ "$corsenabled" = "true" ]; then
		cat << EOF
    # enable CORS
    proxy_cookie_flags ~ SameSite=none;
    more_set_headers 'Access-Control-Allow-Origin: \$cors_header';
    more_set_headers 'Access-Control-Allow-Credentials: true';
    more_set_headers 'Access-Control-Allow-Methods: GET, POST, OPTIONS';
    more_set_headers 'Access-Control-Allow-Headers: Authorization,DNT,X-CustomHeader,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type';
    if (\$request_method = OPTIONS) {
        return 200;
    }
EOF
	else
		echo "    proxy_cookie_flags ~ SameSite=strict;"
	fi

	if [ "$jm_enabled" != "false" ]; then

		cat << EOF
    # main JMobile application
    location / {
        proxy_pass          http://jmobile;
        proxy_buffering     off;
        proxy_cache         off;
        chunked_transfer_encoding off;

        error_page          502 503 504 = @jmuconfig;
        error_log           /dev/null crit;
    }

    location @jmuconfig {
EOF
	else
		cat << EOF
    location / {
EOF
	fi

	cat << EOF
        rewrite     ^ https://\$host\$request_uri? permanent;
    }

    location ^~ ^/(system_settings|machine_config|socket.io|rest|cloud|settings_public)/ {
        rewrite     ^ https://\$host\$request_uri? permanent;
    }

    include /etc/nginx/jml/*.conf;
    include /etc/nginx/proxy_params;
}
EOF

fi

HTTPS_PORT="$(sys_params -l services/web_server/https_port 2> /dev/null)"
[ -z "$HTTPS_PORT" ] && HTTPS_PORT=443

cat << EOF
# external HTTPS requests are proxied to local services
server {
EOF
if [ "${UNPROTECTED}" = "1" ]; then
    echo "    listen                  $HTTPS_PORT;"
else
    echo "    listen                  $HTTPS_PORT ssl;"
    echo "    proxy_cookie_flags ~ secure;"
fi

if [ "$corsenabled" = "true" ]; then
cat << EOF
    # enable CORS
    proxy_cookie_flags ~ SameSite=none;
    more_set_headers 'Access-Control-Allow-Origin: \$cors_header';
    more_set_headers 'Access-Control-Allow-Credentials: true';
    more_set_headers 'Access-Control-Allow-Methods: GET, POST, OPTIONS';
    more_set_headers 'Access-Control-Allow-Headers: Authorization,DNT,X-CustomHeader,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type';
    if (\$request_method = OPTIONS) {
        return 200;
    }
EOF
else
	echo "    proxy_cookie_flags ~ SameSite=strict;"
fi

cat << EOF

    add_header Strict-Transport-Security 'max-age=31536000; includeSubDomains' always;

    ssl_certificate         /etc/ssl/certs/ssl-cert-os.pem;
    ssl_certificate_key     /etc/ssl/private/ssl-cert-os.key;
EOF

if [ "$jm_enabled" != "false" ]; then

	cat << EOF

    # main JMobile application
    location / {
        proxy_pass          http://jmobile;

        error_page          502 504 = @jmuconfig;
        error_log           /dev/null crit;
    }

    # fallback to jmuconfig
    location @jmuconfig {
EOF
else
	cat << EOF

    location / {
EOF
fi

cat << EOF
        proxy_pass              http://jmuconfig;
        proxy_set_header        X-Real-IP \$remote_addr;
        proxy_set_header        Host \$host;
    }

    location /license {
        add_header     Content-Disposition 'attachment; filename="common-licenses.7z"';
        add_header     Strict-Transport-Security 'max-age=31536000; includeSubDomains' always;
EOF
	if [ -e /usr/share/common-licenses.7z ]; then
		echo "        alias          /usr/share/common-licenses.7z;"
	else
		echo "        alias          /mnt/mainos/usr/share/common-licenses.7z;"
	fi

cat << EOF
    }

    location /manifest {
        add_header     Content-Disposition 'attachment; filename="license-manifest.txt"';
        add_header     Strict-Transport-Security 'max-age=31536000; includeSubDomains' always;
EOF
	if [ -e /usr/share/license.manifest ]; then
		echo "        alias          /usr/share/license.manifest;"
	else
		echo "        alias          /mnt/mainos/usr/share/license.manifest;"
	fi

cat << EOF
    }

    # public directory
    location /settings_public {
        alias        /var/www/jmuconfig_public;
        auth_request off;
    }

    location /restsession/ {
        proxy_pass              http://jmuconfig;
        proxy_set_header        X-Real-IP \$remote_addr;
        proxy_set_header        Host \$host;
    }

    location /system_settings/ {
        rewrite                 /system_settings/(.*) /\$1 break;
        proxy_pass              http://jmuconfig;
        proxy_set_header        X-Real-IP \$remote_addr;
        proxy_set_header        Host \$host;
    }

    location /machine_config/ {
        rewrite                 /machine_config/(.*) /\$1 break;
        proxy_pass              http://jmuconfig;
        proxy_set_header        X-Real-IP \$remote_addr;
        proxy_set_header        Host \$host;
    }

    location ~ /(socket\.io|rest|cloud)/ {
        proxy_pass              http://jmuconfig;
        proxy_set_header        X-Real-IP \$remote_addr;
    }

#    location /test/ {
#        rewrite                 /test/(.*) /\$1 break;
#        proxy_pass              http://test;
#    }

    include /etc/nginx/jml/*.conf;
    include /etc/nginx/proxy_params;
}

# JMUConfig internal interface - protected via PAM-based Basic Auth
server {
    listen          127.0.0.1:8080;
EOF

if [ "${UNPROTECTED}" != "1" ]; then
cat << EOF
    auth_request /auth;
    auth_request_set \$x_auth_data \$upstream_http_x_auth_data;
EOF
fi

if [ "$corsenabled" = "true" ]; then
cat << EOF
    # enable CORS
    proxy_cookie_flags ~ SameSite=none;
    more_set_headers 'Access-Control-Allow-Origin: \$cors_header';
    more_set_headers 'Access-Control-Allow-Credentials: true';
    more_set_headers 'Access-Control-Allow-Methods: GET, POST, OPTIONS';
    more_set_headers 'Access-Control-Allow-Headers: Authorization,DNT,X-CustomHeader,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type';
    if (\$request_method = OPTIONS) {
        return 200;
    }
EOF
else
	echo "    proxy_cookie_flags ~ SameSite=strict;"
fi

cat << EOF

    proxy_set_header X-Auth-IP \$remote_addr;
    more_set_headers "Content-Security-Policy: default-src 'self'; style-src 'self' 'unsafe-inline'; script-src 'self' 'unsafe-eval' 'unsafe-inline'; img-src 'self' data:";

    # frontend is served by Nginx
    location / {
        root        /var/www/jmuconfig;
        index       index.html;
        error_page 401 /login;
    }

    # public directory
    location /settings_public {
        alias        /var/www/jmuconfig_public;
        auth_request off;
    }

    location /dyn_modules {
        alias        /mnt/data/dyn_modules/;
    }

    location = /auth {
        internal;
        proxy_pass http://nodejs;
        proxy_pass_request_body off;
        proxy_set_header Content-Length "";
        proxy_set_header X-Original-URI \$request_uri;
    }

    # login page
    location ~ ^/login$ {
        auth_request off;
        proxy_pass http://nodejs;
    }

    # forward login and logout to authsession and disable authentication
    location ~ ^/restsession/api/v1/authentication/(login|logout|keep-alive) {
        auth_request        off;
        rewrite             ^/restsession/api/v1/authentication/(.*) /\$1 break;
        proxy_pass          http://nodejs;
        proxy_redirect      off;
    }

    # REST API requests are stripped of prefix and forwarded to node
    location /restsession/ {
        rewrite             ^/restsession/(.*) /\$1 break;
        proxy_pass          http://nodejs;
        proxy_redirect      off;
        proxy_set_header    Host \$host;
        proxy_set_header    X-Auth-Data \$x_auth_data;

        # Avoid passing basic authentication data since it would not be validated by nginx
        proxy_set_header    Authorization "";
    }

    # REST API requests are stripped of prefix and forwarded to node
    location /rest/ {
        auth_request    off;
        custom_auth     "Restricted Area - login required";
        rewrite             ^/rest/(.*) /\$1 break;
        proxy_pass          http://nodejs;
        proxy_redirect      off;
        proxy_set_header    Host \$host;
    }

    # no authentication for discovery service
    # (used by JMobile! TODO migrate to Avahi?)
    location ~ ^/(rest|restsession)(/api/v1/system/info|/api/v1/system/parameters/options/auth/message(\/\S+)?) {
        auth_request        off;
        rewrite             ^/(?:rest|restsession)/(.*) /\$1 break;
        proxy_pass          http://nodejs;
        proxy_redirect      off;
    }

    # Socket.io requests are forwarded to node as is
    location /socket.io/ {
        proxy_pass                  http://nodejs;
        proxy_http_version          1.1;
    }

    # Cloud requests are stripped of prefix and forwarded to Encloud Service
    location /cloud/ {
        rewrite             ^/cloud/(.*) /\$1 break;
        proxy_pass          http://cloudservice;
        proxy_redirect      off;
    }
}

include /etc/nginx/jml/*.inc;

EOF

BSP_VERSION=$(cat /boot/version)
BSP=${BSP_VERSION:0:4}
if [ "$BSP" == "UN91" ]; then
cat << EOF
server {
    listen 127.0.0.1:15000;
    location /rest/ {
        #custom_auth off;
        #CORS
        more_set_headers 'Access-Control-Allow-Origin: \$http_origin';
        more_set_headers 'Access-Control-Allow-Credentials: true';
        more_set_headers 'Access-Control-Allow-Methods: GET, POST, OPTIONS';
        more_set_headers 'Access-Control-Allow-Headers: Authorization,DNT,X-CustomHeader,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type';
        if (\$request_method = OPTIONS) {
                return 200;
        }
        rewrite             ^/rest/(.*) /\$1 break;
        proxy_pass          http://nodejs;
        proxy_redirect      off;
   }
}
EOF
fi

