#!/bin/bash
#
# Set expire date in /mnt/factory/shadow
set -e
if [ $# -lt 2 ]; then
        echo "Missing arguments."
	echo "Usage: $0 <username> <days> [<warnigdays>, 0=reset,-1=nochange]"
        exit 1
fi

FACTORY_MNT="/mnt/factory/"
ETC_MNT="/etc/"
USERNAME=$1
DAYS=$2
WDAYS=$3

LINE="$(cat /etc/shadow | grep "^$USERNAME:" || true)"
if [ -z "$LINE" ]; then
        echo "Invalid user $USERNAME"
        exit 2
fi

#NOW="$(date +%s)"
#NEWDATE=$(date -d "@$(( "${NOW}" + ${DAYS} * 24 * 60 * 60 ))" +%Y-%m-%d)

mount -o remount,rw "${FACTORY_MNT}"

rm -f "${ETC_MNT}shadow" && cp "${FACTORY_MNT}shadow" "${ETC_MNT}"
rm -f "${ETC_MNT}passwd" && cp "${FACTORY_MNT}passwd" "${ETC_MNT}"
if [ ! -z "$WDAYS" -a "$WDAYS" != "-1" ]; then
    [ "$WDAYS" == "0" ] && WDAYS="-1"
    WDAYSOPT="-W $WDAYS"
fi
chage -I 1 --maxdays "${DAYS}" $WDAYSOPT ${USERNAME}
cp "${ETC_MNT}shadow" "${FACTORY_MNT}" && chgrp shadow "${FACTORY_MNT}shadow"
cp "${ETC_MNT}passwd" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}passwd"
ln -sf "${FACTORY_MNT}shadow" "${ETC_MNT}shadow"
ln -sf "${FACTORY_MNT}passwd" "${ETC_MNT}passwd"
sync

mount -o remount,ro "${FACTORY_MNT}"

exit 0
