#!/bin/sh
# script to make the changes permanent (xinput is called with every Xorg start)
#
# can be used from Xsession.d
# script needs tee and sed (busybox variants are enough)
#
# original script: Martin Jansa <Martin.Jansa@gmail.com>, 2010-01-31
# updated by Tias Guns <tias@ulyssis.org>, 2010-02-15
# updated by Koen Kooi <koen@dominion.thruhere.net>, 2012-02-28

[ ! -d /tmp/.X11-unix ] && exit 1

# BSP-2910 disable calls to xinput during fastboot
[ -e /var/volatile/xinput-inhibit ] && exit 0

PATH="/usr/bin:$PATH"

BINARY="xinput_calibrator"
CALLINK="/etc/pointercal.xinput"
FACTORYMNT="/mnt/factory"
CALDIR="$FACTORYMNT/etc"
CALFILE="$CALDIR/pointercal.xinput"
LOGFILE="/var/log/xinput_calibrator.pointercal.log"

[ -z "$DISPLAY" ] && export DISPLAY=:0

if [ -e $CALLINK ] ; then
  if grep replace $CALLINK ; then
    echo "Empty calibration file found, removing it"
    rm $CALLINK
  else
    echo "Using calibration data stored in $CALLINK"
    . $CALLINK && exit 0
    if [ "$1" = "--restore" ]; then
      for i in 1 2 3 4 5; do
        sleep 1
        . $CALLINK && exit 0
      done
    fi
  fi
fi

[ "$1" = "--restore" ] && exit 0

TMPDIR=/mnt/.psplash psplash-write "QUIT"

CALDATA=`$BINARY --output-type xinput -v | tee $LOGFILE | grep '    xinput set' | sed 's/^    //g; s/$/;/g'`
if [ ! -z "$CALDATA" ] ; then
  mount -o remount,rw $FACTORYMNT
  mkdir -p $CALDIR
  echo $CALDATA > $CALFILE
  mount -o remount,ro $FACTORYMNT
  ln -sf $CALFILE $CALLINK
  echo "Calibration data stored in $CALFILE (log in $LOGFILE)"
fi
